// Theme toggle
const themeToggle = document.getElementById('themeToggle');
if (themeToggle) {
  themeToggle.addEventListener('click', () => {
    document.documentElement.classList.toggle('dark');
  });
}

// Year
const yearEl = document.getElementById('year');
if (yearEl) yearEl.textContent = new Date().getFullYear();

// Demo data
const SITES = [
  { id: 1, domain: 'techpulse.io', niche: 'Teknoloji', dr: 72, da: 65, traffic: 185000, price: 180, dofollow: true, sponsored: false, lang:'EN', samples:['/sample1','/sample2'] },
  { id: 2, domain: 'healthdaily.co', niche: 'Sağlık', dr: 58, da: 52, traffic: 94000, price: 120, dofollow: true, sponsored: true, lang:'EN', samples:['/sample3'] },
  { id: 3, domain: 'finwise.net', niche: 'Finans', dr: 67, da: 61, traffic: 121000, price: 220, dofollow: true, sponsored: false, lang:'EN', samples:['/s1'] },
  { id: 4, domain: 'livingvibes.com', niche: 'Yaşam', dr: 42, da: 39, traffic: 38000, price: 70, dofollow: false, sponsored: true, lang:'EN', samples:[] },
  { id: 5, domain: 'eduspark.org', niche: 'Eğitim', dr: 54, da: 48, traffic: 61000, price: 95, dofollow: true, sponsored: false, lang:'EN', samples:['/s2'] },
  { id: 6, domain: 'ai-hub.dev', niche: 'Teknoloji', dr: 78, da: 70, traffic: 245000, price: 260, dofollow: true, sponsored: false, lang:'EN', samples:['/s3'] },
  { id: 7, domain: 'fitandfresh.blog', niche: 'Sağlık', dr: 36, da: 34, traffic: 22000, price: 55, dofollow: false, sponsored: true, lang:'EN', samples:[] },
  { id: 8, domain: 'moneymentor.blog', niche: 'Finans', dr: 45, da: 43, traffic: 47000, price: 80, dofollow: true, sponsored: false, lang:'EN', samples:['/s4'] },
  { id: 9, domain: 'learnmate.edu', niche: 'Eğitim', dr: 61, da: 58, traffic: 91000, price: 140, dofollow: true, sponsored: false, lang:'EN', samples:[] },
  { id: 10, domain: 'geekstreet.tech', niche: 'Teknoloji', dr: 51, da: 49, traffic: 50000, price: 90, dofollow: true, sponsored: false, lang:'EN', samples:['/s5'] },
  { id: 11, domain: 'medpedia.info', niche: 'Sağlık', dr: 73, da: 69, traffic: 210000, price: 275, dofollow: true, sponsored: false, lang:'EN', samples:['/s6'] },
  { id: 12, domain: 'urbanliving.co', niche: 'Yaşam', dr: 57, da: 55, traffic: 77000, price: 110, dofollow: false, sponsored: true, lang:'EN', samples:[] },
];

let filtered = [...SITES];
let cart = [];
let compare = [];
let page = 1; const perPage = 6;

// Elements (some may not exist on every page)
const marketList = document.getElementById('marketList');
const skeletons = document.getElementById('skeletons');
const emptyState = document.getElementById('emptyState');
const loadMore = document.getElementById('loadMore');

const searchInput = document.getElementById('searchInput');
const nicheSelect = document.getElementById('nicheSelect');
const minDr = document.getElementById('minDr');
const minDrVal = document.getElementById('minDrVal');
const minTraffic = document.getElementById('minTraffic');
const minTrafficVal = document.getElementById('minTrafficVal');
const priceMin = document.getElementById('priceMin');
const priceMax = document.getElementById('priceMax');
const dofollowOnly = document.getElementById('dofollowOnly');
const allowSponsored = document.getElementById('allowSponsored');

const sortSelect = document.getElementById('sortSelect');
const sortSelectMobile = document.getElementById('sortSelectMobile');

const applyFiltersBtn = document.getElementById('applyFilters');
const clearFiltersBtn = document.getElementById('clearFilters');

const cartDrawer = document.getElementById('cartDrawer');
const openCart = document.getElementById('openCart');
const closeCart = document.getElementById('closeCart');
const closeCartOverlay = document.getElementById('closeCartOverlay');
const cartItems = document.getElementById('cartItems');
const cartCount = document.getElementById('cartCount');
const cartTotal = document.getElementById('cartTotal');
const checkoutBtn = document.getElementById('checkoutBtn');

const checkoutModal = document.getElementById('checkoutModal');
const closeCheckout = document.getElementById('closeCheckout');

const compareDrawer = document.getElementById('compareDrawer');
const openCompare = document.getElementById('openCompare');
const compareItems = document.getElementById('compareItems');

const detailModal = document.getElementById('detailModal');
const detailTitle = document.getElementById('detailTitle');
const detailBody = document.getElementById('detailBody');

const toast = document.getElementById('toast');

const statSites = document.getElementById('statSites');
const statDR = document.getElementById('statDR');
const statTraffic = document.getElementById('statTraffic');

const formatMoney = (n) => "$" + n.toLocaleString('en-US', { maximumFractionDigits: 0 });

function setStats() {
  if (!(statSites && statDR && statTraffic)) return;
  const total = SITES.length;
  const avgDR = Math.round(SITES.reduce((a,s)=>a+s.dr,0)/total);
  const sumTraffic = SITES.reduce((a,s)=>a+s.traffic,0);
  statSites.textContent = total;
  statDR.textContent = avgDR;
  statTraffic.textContent = sumTraffic.toLocaleString('tr-TR');
}
setStats();

function showToast(msg) {
  if (!toast) return;
  toast.firstElementChild.textContent = msg;
  toast.classList.remove('hidden');
  setTimeout(()=> toast.classList.add('hidden'), 1600);
}

function paginate(arr){
  const start = (page-1)*perPage; return arr.slice(start, start+perPage);
}

function renderList(reset=true) {
  if (!marketList) return;
  if (reset) { marketList.innerHTML=''; page=1; }
  const view = paginate(filtered);
  if (skeletons) skeletons.classList.add('hidden');
  if (emptyState) emptyState.classList.add('hidden');

  if (!view.length && page===1) { 
    if (emptyState) emptyState.classList.remove('hidden'); 
    if (loadMore) loadMore.classList.add('hidden'); 
    return; 
  }

  view.forEach(item => marketList.appendChild(renderCard(item)));
  const more = filtered.length > page*perPage; 
  if (loadMore) loadMore.classList.toggle('hidden', !more);
  bindCardEvents();
}

function renderCard(item){
  const card = document.createElement('div');
  card.className = 'rounded-2xl border border-slate-200 dark:border-slate-800 bg-white dark:bg-slate-900 p-4 shadow-soft flex flex-col fade-in';
  card.innerHTML = `
    <div class="flex items-start justify-between gap-2">
      <div>
        <div class="text-sm text-slate-500">${item.niche}</div>
        <button class="text-left text-lg font-extrabold hover:underline domain-btn" data-id="${item.id}">${item.domain}</button>
      </div>
      <div class="text-right">
        <div class="text-xs text-slate-500">Fiyat</div>
        <div class="text-base font-bold">${formatMoney(item.price)}</div>
      </div>
    </div>
    <div class="mt-3 grid grid-cols-3 gap-2 text-center text-sm">
      <div class="rounded-xl border border-slate-200 dark:border-slate-800 p-2"><div class="text-xs text-slate-500">DR</div><div class="font-semibold">${item.dr}</div></div>
      <div class="rounded-xl border border-slate-200 dark:border-slate-800 p-2"><div class="text-xs text-slate-500">DA</div><div class="font-semibold">${item.da}</div></div>
      <div class="rounded-xl border border-slate-200 dark:border-slate-800 p-2"><div class="text-xs text-slate-500">Trafik</div><div class="font-semibold">${item.traffic.toLocaleString('tr-TR')}</div></div>
    </div>
    <div class="mt-3 flex items-center justify-between text-sm">
      <div class="flex items-center gap-3">
        <span class="inline-flex items-center gap-2 ${item.dofollow ? 'text-emerald-600' : 'text-amber-600'}"><span>${item.dofollow ? '●' : '○'}</span>${item.dofollow ? 'Dofollow' : 'Nofollow'}</span>
        ${item.sponsored ? '<span class="text-xs px-2 py-0.5 rounded-full border border-slate-200 dark:border-slate-800">Sponsored</span>' : ''}
      </div>
      <div class="flex items-center gap-2">
        <button data-id="${item.id}" class="compare-btn rounded-xl border border-slate-200 dark:border-slate-800 px-3 py-2">Karşılaştır</button>
        <button data-id="${item.id}" class="add-to-cart rounded-xl bg-brand-600 text-white font-semibold px-3 py-2 hover:bg-brand-700">Sepete Ekle</button>
      </div>
    </div>`;
  return card;
}

function bindCardEvents(){
  if (!marketList) return;
  marketList.querySelectorAll('.add-to-cart').forEach(btn=>{
    btn.addEventListener('click', ()=>{
      const id = Number(btn.getAttribute('data-id'));
      const item = SITES.find(s=>s.id===id);
      addToCart({ type:'site', name:item.domain, price:item.price });
      showToast('Sepete eklendi ✅');
    })
  });
  marketList.querySelectorAll('.compare-btn').forEach(btn=>{
    btn.addEventListener('click', ()=>{
      const id = Number(btn.getAttribute('data-id'));
      const item = SITES.find(s=>s.id===id);
      if (!compare.some(c=>c.id===id)) compare.push(item);
      renderCompare();
      openCompareDrawer();
    })
  });
  marketList.querySelectorAll('.domain-btn').forEach(btn=>{
    btn.addEventListener('click', ()=>{
      const id = Number(btn.getAttribute('data-id'));
      const item = SITES.find(s=>s.id===id);
      openDetail(item);
    })
  });
}

function addToCart(item){ 
  if (!(cartItems && cartTotal && cartCount)) return;
  cart.push({ ...item, id: Date.now() + Math.random() }); renderCart(); 
}
function removeFromCart(id){ cart = cart.filter(i=>i.id!==id); renderCart(); }
function renderCart(){
  if (!(cartItems && cartTotal && cartCount)) return;
  cartItems.innerHTML='';
  if(!cart.length){ cartItems.innerHTML='<div class="text-sm text-slate-500 py-6 text-center">Sepetiniz boş</div>'; }
  let total=0;
  cart.forEach(item=>{
    total += item.price;
    const row=document.createElement('div');
    row.className='py-3 flex items-center justify-between gap-3';
    row.innerHTML=`<div><div class="font-semibold">${item.name}</div><div class="text-xs text-slate-500">${item.type==='site'?'Yayıncı':'Paket'}</div></div><div class="flex items-center gap-3"><div class="font-semibold">${formatMoney(item.price)}</div><button class="remove rounded-lg border border-slate-200 dark:border-slate-800 px-2 py-1 text-xs" data-id="${item.id}">Sil</button></div>`;
    cartItems.appendChild(row);
  });
  cartTotal.textContent = formatMoney(total);
  cartCount.textContent = cart.length;
  cartItems.querySelectorAll('.remove').forEach(b=> b.addEventListener('click', ()=> removeFromCart(Number(b.getAttribute('data-id')))));
}

// Filters & sorting
function applyFilters(){
  if (!marketList) return;
  const q = (searchInput?.value||'').toLowerCase();
  const niche = nicheSelect?.value || '';
  const minDrValNum = Number(minDr?.value || 0);
  const minTrafficNum = Number(minTraffic?.value || 0);
  const pMin = priceMin?.value ? Number(priceMin.value) : -Infinity;
  const pMax = priceMax?.value ? Number(priceMax.value) : Infinity;
  const onlyFollow = !!(dofollowOnly && dofollowOnly.checked);
  const allowS = !!(allowSponsored && allowSponsored.checked);

  filtered = SITES.filter(s=>{
    const matchesQ = s.domain.toLowerCase().includes(q) || s.niche.toLowerCase().includes(q);
    const matchesNiche = !niche || s.niche===niche;
    const matchesDr = s.dr >= minDrValNum;
    const matchesTraffic = s.traffic >= minTrafficNum;
    const matchesPrice = s.price >= pMin && s.price <= pMax;
    const matchesFollow = !onlyFollow || s.dofollow;
    const matchesSponsored = allowS ? true : !s.sponsored;
    return matchesQ && matchesNiche && matchesDr && matchesTraffic && matchesPrice && matchesFollow && matchesSponsored;
  });

  const sortVal = (sortSelect?.value || sortSelectMobile?.value || 'relevance');
  if (sortVal==='priceAsc') filtered.sort((a,b)=>a.price-b.price);
  if (sortVal==='priceDesc') filtered.sort((a,b)=>b.price-a.price);
  if (sortVal==='drDesc') filtered.sort((a,b)=>b.dr-a.dr);
  if (sortVal==='trafficDesc') filtered.sort((a,b)=>b.traffic-a.traffic);

  renderList(true);
}

if (applyFiltersBtn) applyFiltersBtn.addEventListener('click', applyFilters);
[sortSelect, sortSelectMobile].forEach(el => el?.addEventListener('change', applyFilters));
if (clearFiltersBtn) clearFiltersBtn.addEventListener('click', () => {
  if (!marketList) return;
  if (searchInput) searchInput.value = '';
  if (nicheSelect) nicheSelect.value = '';
  if (minDr) { minDr.value = 0; if (minDrVal) minDrVal.textContent = '0'; }
  if (minTraffic) { minTraffic.value = 0; if (minTrafficVal) minTrafficVal.textContent = '0'; }
  if (priceMin) priceMin.value = '';
  if (priceMax) priceMax.value = '';
  if (dofollowOnly) dofollowOnly.checked = false;
  if (allowSponsored) allowSponsored.checked = false;
  filtered = [...SITES];
  if (sortSelect) sortSelect.value = 'relevance'; 
  if (sortSelectMobile) sortSelectMobile.value = 'relevance';
  renderList(true);
});

if (minDr) minDr.addEventListener('input', ()=> { if (minDrVal) minDrVal.textContent = minDr.value; });
if (minTraffic) minTraffic.addEventListener('input', ()=> { if (minTrafficVal) minTrafficVal.textContent = minTraffic.value; });

// Cart open/close
function openCartDrawer(){ cartDrawer?.classList.remove('hidden'); }
function closeCartDrawer(){ cartDrawer?.classList.add('hidden'); }
openCart?.addEventListener('click', openCartDrawer);
closeCart?.addEventListener('click', closeCartDrawer);
closeCartOverlay?.addEventListener('click', closeCartDrawer);

// Checkout
checkoutBtn?.addEventListener('click', () => {
  if (!cart.length) { alert('Ödeme için sepetinizde ürün bulunmalı.'); return; }
  checkoutModal?.classList.remove('hidden');
});
closeCheckout?.addEventListener('click', ()=> checkoutModal?.classList.add('hidden'));
document.getElementById('checkoutForm')?.addEventListener('submit', (e) => {
  e.preventDefault();
  alert('Demo: Ödeme başarılı varsayıldı. Siparişiniz alınmıştır.');
  checkoutModal?.classList.add('hidden');
  cart = []; renderCart(); closeCartDrawer();
});

// Contact
document.getElementById('contactForm')?.addEventListener('submit', (e) => {
  e.preventDefault();
  alert('Mesajınız alındı! En kısa sürede dönüş yapacağız.');
  e.target.reset();
});

// Compare
function openCompareDrawer(){ compareDrawer?.classList.remove('hidden'); }
function closeCompareDrawer(){ compareDrawer?.classList.add('hidden'); }
document.querySelectorAll('[data-close="compare"]').forEach(el=> el.addEventListener('click', closeCompareDrawer));
document.getElementById('clearCompare')?.addEventListener('click', ()=>{ compare=[]; renderCompare(); });
function renderCompare(){
  if (!compareItems) return;
  compareItems.innerHTML='';
  if(!compare.length){ compareItems.innerHTML='<div class="text-sm text-slate-500 py-6 text-center">Liste boş</div>'; return; }
  compare.forEach(item=>{
    const row=document.createElement('div');
    row.className='py-3 flex items-center justify-between gap-3';
    row.innerHTML=`<div><div class="font-semibold">${item.domain}</div><div class="text-xs text-slate-500">DR ${item.dr} • DA ${item.da} • Trafik ${item.traffic.toLocaleString('tr-TR')}</div></div><div class="font-semibold">${formatMoney(item.price)}</div>`;
    compareItems.appendChild(row);
  });
}
openCompare?.addEventListener('click', openCompareDrawer);

// Detail modal
document.querySelectorAll('[data-close="detail"]').forEach(el=> el.addEventListener('click', ()=> detailModal?.classList.add('hidden')));
function openDetail(item){
  if (!(detailModal && detailTitle && detailBody)) return;
  detailTitle.textContent = item.domain;
  detailBody.innerHTML = `
    <div class="grid sm:grid-cols-2 gap-3">
      <div class="rounded-xl border border-slate-200 dark:border-slate-800 p-3"><div class="text-xs text-slate-500">Niş</div><div class="font-semibold">${item.niche}</div></div>
      <div class="rounded-xl border border-slate-200 dark:border-slate-800 p-3"><div class="text-xs text-slate-500">Dil</div><div class="font-semibold">${item.lang}</div></div>
      <div class="rounded-xl border border-slate-200 dark:border-slate-800 p-3"><div class="text-xs text-slate-500">DR / DA</div><div class="font-semibold">${item.dr} / ${item.da}</div></div>
      <div class="rounded-xl border border-slate-200 dark:border-slate-800 p-3"><div class="text-xs text-slate-500">Aylık Trafik</div><div class="font-semibold">${item.traffic.toLocaleString('tr-TR')}</div></div>
      <div class="rounded-xl border border-slate-200 dark:border-slate-800 p-3"><div class="text-xs text-slate-500">Link</div><div class="font-semibold">${item.dofollow? 'Dofollow' : 'Nofollow'} ${item.sponsored?'• Sponsored':''}</div></div>
      <div class="rounded-xl border border-slate-200 dark:border-slate-800 p-3"><div class="text-xs text-slate-500">Fiyat</div><div class="font-semibold">${formatMoney(item.price)}</div></div>
    </div>
    <div class="mt-3"><div class="text-xs text-slate-500">Örnekler</div><div>${item.samples.length? item.samples.map(s=>`<a class='underline' href='#'>${s}</a>`).join(' • ') : '—'}</div></div>
    <div class="mt-4 flex justify-end gap-2">
      <button class="compare-on-detail rounded-xl border border-slate-200 dark:border-slate-800 px-3 py-2" data-id="${item.id}">Karşılaştır</button>
      <button class="add-on-detail rounded-xl bg-brand-600 text-white font-semibold px-3 py-2" data-id="${item.id}">Sepete Ekle</button>
    </div>`;
  detailModal.classList.remove('hidden');
  detailBody.querySelector('.compare-on-detail')?.addEventListener('click', ()=>{ if(!compare.some(c=>c.id===item.id)){ compare.push(item); renderCompare(); } openCompareDrawer(); });
  detailBody.querySelector('.add-on-detail')?.addEventListener('click', ()=>{ addToCart({type:'site', name:item.domain, price:item.price}); showToast('Sepete eklendi ✅'); });
}

// Market page init
if (marketList) {
  // initial paint
  filtered = [...SITES];
  renderList(true);
  const more = filtered.length > page*perPage; 
  if (loadMore) loadMore.classList.toggle('hidden', !more);
  loadMore?.addEventListener('click', ()=>{ page += 1; renderList(false); });
}